function [ERT,pitstoptime,parameters,covarmatrix] = estimatedRaceTime(car,laps,wr,numberOfStints,fuel,tank)
%ESTIMATEDRACETIME Summary of this function goes here
%   Detailed explanation goes here

%% fixed values
fuelflow=0.2; %in [s/l]
tyrechange=13; %in [s]

%% car

%% calculations
wr=laptime_to_seconds(wr);
stintdistance=500/numberOfStints;
pitstops=numberOfStints-1;
refuelling=tank*fuel/100; %in [l]

[averagelap,parameters,covarmatrix,statistics]=laptime_LS_adjustment(car,stintdistance);

pitstoptime=pitstops*(tyrechange+fuelflow*refuelling)
ERT=averagelap*wr*laps+pitstoptime

end

